import { ChecksumAlgorithm, ChecksumConfiguration, ChecksumConstructor, HashConstructor } from "@smithy/types";
import { AlgorithmId } from "@smithy/types";
export { AlgorithmId, ChecksumAlgorithm, ChecksumConfiguration };
/**
 * @internal
 */
export declare const getChecksumConfiguration: (runtimeConfig: Partial<{
    sha256: ChecksumConstructor | HashConstructor;
    md5: ChecksumConstructor | HashConstructor;
}>) => {
    _checksumAlgorithms: ChecksumAlgorithm[];
    addChecksumAlgorithm(algo: ChecksumAlgorithm): void;
    checksumAlgorithms(): ChecksumAlgorithm[];
};
/**
 * @internal
 */
export declare const resolveChecksumRuntimeConfig: (clientConfig: ChecksumConfiguration) => Partial<Record<AlgorithmId, HashConstructor | ChecksumConstructor>>;
